/* GuiBom.groovy
July 2008 by John Green

Generates XML Bill of Materials for GUI elements.

--- USAGE ---
o  NOTE that ProRefactor writes potentially large amounts of data,
   and that this script may use large amounts of CPU, memory, and disc space.

o  You must have ProRefactor and Groovy scripting set up. See:
   http://www.oehive.org/prorefactor/standalone_jar_file

o  Configure guibom.properties in your current working directory.

o  Run the script: groovy src/GuiBom.groovy
-------------

Copyright (C) 2008 Joanju Software (www.joanju.com). All rights reserved.
This file is made available under the terms of the Eclipse Public License v1.0.
*/

import org.prorefactor.refactor.RefactorSession
import org.prorefactor.treeparser.ParseUnit

class GuiBom implements Runnable {

	Logger logger
	RefactorSession prsession = RefactorSession.instance
	ScriptSupport support
	String relativePath


	void run() {
		support = new ScriptSupport('guibom.properties', 'guibom.log')
		support.hasPrepend = false
		try {
			if (! support.initialize())
				return
			run2_fileList()
		} finally {
			support.close()
		}
	}


	void run2_fileList() {
		logger = support.logger

		// Loop all compile units from the selection.
		for (File file in support.fileScanner) {
			relativePath = support.relativePath(file)
			logger.log(relativePath + ' ')
			def parseUnit = new ParseUnit(file)
			try {
				// Parse the source file.
				// We can't work from ProRefactor's binary stored syntax trees,
				// because those don't store original text from keyword tokens.
				parseUnit.treeParser01()
			} catch (Exception e) {
				// Show and log parse errors.
				logger.logLine(e.message)
				continue
			}
			def unitBuilder = new GuiBomUnit(parseUnit, support)
			unitBuilder.build()
			def outfile = new File(support.outputDir.path + '/' + relativePath + '.xml')
			outfile.write(unitBuilder.getText())
			logger.newline()
		}
	}


}
