/* joanju/programfiles.p */

{joanju/allfilestable.i}

def input parameter dirname as character no-undo.
def input-output parameter table for allFilesTable append.

def buffer possibleProgramFile for allFilesTable.


FILE-INFO:FILE-NAME = dirname.

IF FILE-INFO:FILE-TYPE = ?
   OR INDEX(FILE-INFO:FILE-TYPE, "D":U) = 0
   THEN DO:
  MESSAGE "Invalid directory name" VIEW-AS ALERT-BOX.
  RETURN.
END.


/* Replace any relative file name with the full path. */
def var dirpath as character no-undo.

ASSIGN dirpath = FILE-INFO:FULL-PATHNAME.
RUN recurseDirectory(dirpath).
RETURN.



PROCEDURE recurseDirectory:
  DEFINE INPUT PARAMETER dirName AS CHARACTER NO-UNDO.
  DEFINE VARIABLE basename AS CHARACTER NO-UNDO.
  DEFINE VARIABLE fullpath AS CHARACTER NO-UNDO.
  DEFINE VARIABLE attribs  AS CHARACTER NO-UNDO.
  FILE-INFO:FILE-NAME = dirName.
  INPUT FROM OS-DIR (FILE-INFO:FULL-PATHNAME).
  REPEAT:
    IMPORT basename fullpath attribs.
    IF attribs MATCHES "*D*" AND NOT(basename="." OR basename="..") THEN
      RUN recurseDirectory(fullpath).
    IF (   attribs MATCHES "*F*"
       AND (  NOT (basename MATCHES "*~~.r") )
       )
	     THEN DO:
      create possibleProgramFile.
      possibleProgramFile.filename = fullpath.
    END.
  END.
  INPUT CLOSE.
END PROCEDURE.




