&ANALYZE-SUSPEND _VERSION-NUMBER UIB_v9r12 GUI
&ANALYZE-RESUME
&Scoped-define WINDOW-NAME CURRENT-WINDOW
&Scoped-define FRAME-NAME Dialog-Frame
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _DEFINITIONS Dialog-Frame 
/*------------------------------------------------------------------------

  File: textprompt.w

  Description: Simple text prompting dialog

  RETURNS: "cancel" if cancel button pressed

  Input Parameters:
      Character: Descriptive text, displayed in edit widget

  Input-Output Parameters:
      Character: Input default value, output user entered text

  Author: John Green, Joanju Limited

  Created: 2001
------------------------------------------------------------------------*/
/*          This .W file was created with the Progress AppBulder.       */
/*----------------------------------------------------------------------*/

/* ***************************  Definitions  ************************** */

/* Parameters Definitions ---                                           */
DEFINE INPUT PARAMETER Pdescription AS CHARACTER NO-UNDO.
DEFINE INPUT-OUTPUT PARAMETER Pvalue AS CHARACTER NO-UNDO.

DEFINE INPUT PARAMETER Pdescription2 AS CHARACTER NO-UNDO.
DEFINE INPUT-OUTPUT PARAMETER Pvalue2 AS CHARACTER NO-UNDO.

/* Local Variable Definitions ---                                       */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-PREPROCESSOR-BLOCK 

/* ********************  Preprocessor Definitions  ******************** */

&Scoped-define PROCEDURE-TYPE Dialog-Box
&Scoped-define DB-AWARE no

&Scoped-define LAYOUT-VARIABLE CURRENT-WINDOW-layout

/* Name of first Frame and/or Browse and/or first Query                 */
&Scoped-define FRAME-NAME Dialog-Frame

/* Standard List Definitions                                            */
&Scoped-Define ENABLED-OBJECTS FILL-IN-1 FILL-IN-2 Btn_OK Btn_Cancel ~
EDITOR-1 EDITOR-2 
&Scoped-Define DISPLAYED-OBJECTS FILL-IN-1 FILL-IN-2 EDITOR-1 EDITOR-2 

/* Custom List Definitions                                              */
/* List-1,List-2,List-3,List-4,List-5,List-6                            */

/* _UIB-PREPROCESSOR-BLOCK-END */
&ANALYZE-RESUME



/* Define a variable to store the name of the active layout.            */
DEFINE VAR CURRENT-WINDOW-layout AS CHAR INITIAL "Master Layout":U NO-UNDO.

/* ***********************  Control Definitions  ********************** */

/* Define a dialog box                                                  */

/* Definitions of the field level widgets                               */
DEFINE BUTTON Btn_Cancel AUTO-END-KEY 
     LABEL "Cancel" 
     &IF '{&WINDOW-SYSTEM}' = 'TTY':U &THEN SIZE 15 BY 1
     &ELSE SIZE 15 BY 1.14 &ENDIF
     BGCOLOR 8 .

DEFINE BUTTON Btn_OK AUTO-GO 
     LABEL "OK" 
     &IF '{&WINDOW-SYSTEM}' = 'TTY':U &THEN SIZE 15 BY 1
     &ELSE SIZE 15 BY 1.14 &ENDIF
     BGCOLOR 8 .

DEFINE VARIABLE EDITOR-1 AS CHARACTER 
     VIEW-AS EDITOR
     &IF '{&WINDOW-SYSTEM}' = 'TTY':U &THEN SIZE 44 BY 4
     &ELSE SIZE 44 BY 3.81 &ENDIF NO-UNDO.

DEFINE VARIABLE EDITOR-2 AS CHARACTER 
     VIEW-AS EDITOR
     &IF '{&WINDOW-SYSTEM}' = 'TTY':U &THEN SIZE 44 BY 4
     &ELSE SIZE 44 BY 3.81 &ENDIF NO-UNDO.

DEFINE VARIABLE FILL-IN-1 AS CHARACTER FORMAT "X(256)":U 
     VIEW-AS FILL-IN 
     &IF '{&WINDOW-SYSTEM}' = 'TTY':U &THEN SIZE 60 BY 1
     &ELSE SIZE 60 BY 1 &ENDIF NO-UNDO.

DEFINE VARIABLE FILL-IN-2 AS CHARACTER FORMAT "X(256)":U 
     VIEW-AS FILL-IN 
     &IF '{&WINDOW-SYSTEM}' = 'TTY':U &THEN SIZE 60 BY 1
     &ELSE SIZE 60 BY 1 &ENDIF NO-UNDO.


/* ************************  Frame Definitions  *********************** */

DEFINE FRAME Dialog-Frame
     FILL-IN-1
          &IF '{&WINDOW-SYSTEM}' = 'TTY':U &THEN AT ROW 6 COL 3
          &ELSE AT ROW 5.52 COL 3 &ENDIF NO-LABEL
     FILL-IN-2
          &IF '{&WINDOW-SYSTEM}' = 'TTY':U &THEN AT ROW 11 COL 3
          &ELSE AT ROW 11 COL 3 &ENDIF NO-LABEL
     Btn_OK
          &IF '{&WINDOW-SYSTEM}' = 'TTY':U &THEN AT ROW 6 COL 49
          &ELSE AT ROW 1.52 COL 49 &ENDIF
     Btn_Cancel
          &IF '{&WINDOW-SYSTEM}' = 'TTY':U &THEN AT ROW 7 COL 49
          &ELSE AT ROW 2.76 COL 49 &ENDIF
     EDITOR-1
          &IF '{&WINDOW-SYSTEM}' = 'TTY':U &THEN AT ROW 1 COL 3
          &ELSE AT ROW 1.48 COL 3 &ENDIF NO-LABEL
     EDITOR-2
          &IF '{&WINDOW-SYSTEM}' = 'TTY':U &THEN AT ROW 7 COL 3
          &ELSE AT ROW 6.95 COL 3 &ENDIF NO-LABEL
     SPACE(18.19) SKIP(1.52)
    WITH VIEW-AS DIALOG-BOX KEEP-TAB-ORDER 
         SIDE-LABELS NO-UNDERLINE THREE-D  SCROLLABLE 
         TITLE ""
         DEFAULT-BUTTON Btn_OK CANCEL-BUTTON Btn_Cancel.


/* *********************** Procedure Settings ************************ */

&ANALYZE-SUSPEND _PROCEDURE-SETTINGS
/* Settings for THIS-PROCEDURE
   Type: Dialog-Box
   Allow: Basic,Browse,DB-Fields,Query
   Other Settings: COMPILE
 */
&ANALYZE-RESUME _END-PROCEDURE-SETTINGS



/* ***********  Runtime Attributes and AppBuilder Settings  *********** */

&ANALYZE-SUSPEND _RUN-TIME-ATTRIBUTES
/* SETTINGS FOR DIALOG-BOX Dialog-Frame
   Custom                                                               */
ASSIGN 
       FRAME Dialog-Frame:SCROLLABLE       = FALSE
       FRAME Dialog-Frame:HIDDEN           = TRUE.

ASSIGN 
       EDITOR-1:READ-ONLY IN FRAME Dialog-Frame        = TRUE.

ASSIGN 
       EDITOR-2:READ-ONLY IN FRAME Dialog-Frame        = TRUE.

/* SETTINGS FOR FILL-IN FILL-IN-1 IN FRAME Dialog-Frame
   ALIGN-L                                                              */
/* SETTINGS FOR FILL-IN FILL-IN-2 IN FRAME Dialog-Frame
   ALIGN-L                                                              */

/* _MULTI-LAYOUT-RUN-TIME-ADJUSTMENTS */

/* LAYOUT-NAME: "Standard Character"
   LAYOUT-TYPE: CHARACTER
   EXPRESSION:  SESSION:DISPLAY-TYPE = 'TTY':U 
   COMMENT:     This layout is the standard layout specification for
                 a customized Character based terminal.  It is usually
                 selected to modify a window that has a GUI based
                 master layout.
                                                                        */
IF SESSION:DISPLAY-TYPE = 'TTY':U  THEN 
  RUN CURRENT-WINDOW-layouts (INPUT 'Standard Character':U) NO-ERROR.

/* END-OF-LAYOUT-DEFINITIONS */

/* _RUN-TIME-ATTRIBUTES-END */
&ANALYZE-RESUME

 



/* ************************  Control Triggers  ************************ */

&Scoped-define SELF-NAME Dialog-Frame
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL Dialog-Frame Dialog-Frame
ON WINDOW-CLOSE OF FRAME Dialog-Frame
DO:
  APPLY "END-ERROR":U TO SELF.
END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME Btn_Cancel
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL Btn_Cancel Dialog-Frame
ON CHOOSE OF Btn_Cancel IN FRAME Dialog-Frame /* Cancel */
DO:
  RETURN "cancel".
END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME Btn_OK
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL Btn_OK Dialog-Frame
ON CHOOSE OF Btn_OK IN FRAME Dialog-Frame /* OK */
DO:
  ASSIGN 
    Pvalue  = INPUT FILL-IN-1
    Pvalue2 = INPUT FILL-IN-2.
END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&UNDEFINE SELF-NAME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _MAIN-BLOCK Dialog-Frame 


/* ***************************  Main Block  *************************** */

/* Parent the dialog-box to the ACTIVE-WINDOW, if there is no parent.   */
IF VALID-HANDLE(ACTIVE-WINDOW) AND FRAME {&FRAME-NAME}:PARENT eq ?
THEN FRAME {&FRAME-NAME}:PARENT = ACTIVE-WINDOW.


ASSIGN
  EDITOR-1 = Pdescription
  FILL-IN-1 = Pvalue
  EDITOR-2 = Pdescription2
  FILL-IN-2 = Pvalue2.

/* Now enable the interface and wait for the exit condition.            */
/* (NOTE: handle ERROR and END-KEY so cleanup code will always fire.    */
MAIN-BLOCK:
DO ON ERROR   UNDO MAIN-BLOCK, LEAVE MAIN-BLOCK
   ON END-KEY UNDO MAIN-BLOCK, LEAVE MAIN-BLOCK:
  RUN enable_UI.
  WAIT-FOR GO OF FRAME {&FRAME-NAME}.
END.
RUN disable_UI.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


/* **********************  Internal Procedures  *********************** */

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE disable_UI Dialog-Frame  _DEFAULT-DISABLE
PROCEDURE disable_UI :
/*------------------------------------------------------------------------------
  Purpose:     DISABLE the User Interface
  Parameters:  <none>
  Notes:       Here we clean-up the user-interface by deleting
               dynamic widgets we have created and/or hide 
               frames.  This procedure is usually called when
               we are ready to "clean-up" after running.
------------------------------------------------------------------------------*/
  /* Hide all frames. */
  HIDE FRAME Dialog-Frame.
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE enable_UI Dialog-Frame  _DEFAULT-ENABLE
PROCEDURE enable_UI :
/*------------------------------------------------------------------------------
  Purpose:     ENABLE the User Interface
  Parameters:  <none>
  Notes:       Here we display/view/enable the widgets in the
               user-interface.  In addition, OPEN all queries
               associated with each FRAME and BROWSE.
               These statements here are based on the "Other 
               Settings" section of the widget Property Sheets.
------------------------------------------------------------------------------*/
  DISPLAY FILL-IN-1 FILL-IN-2 EDITOR-1 EDITOR-2 
      WITH FRAME Dialog-Frame.
  ENABLE FILL-IN-1 FILL-IN-2 Btn_OK Btn_Cancel EDITOR-1 EDITOR-2 
      WITH FRAME Dialog-Frame.
  VIEW FRAME Dialog-Frame.
  {&OPEN-BROWSERS-IN-QUERY-Dialog-Frame}
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK  _PROCEDURE CURRENT-WINDOW-layouts _LAYOUT-CASES
PROCEDURE CURRENT-WINDOW-layouts:
  DEFINE INPUT PARAMETER layout AS CHARACTER                     NO-UNDO.
  DEFINE VARIABLE lbl-hndl AS WIDGET-HANDLE                      NO-UNDO.
  DEFINE VARIABLE widg-pos AS DECIMAL                            NO-UNDO.

  /* Copy the name of the active layout into a variable accessible to   */
  /* the rest of this file.                                             */
  CURRENT-WINDOW-layout = layout.

  CASE layout:
    WHEN "Master Layout" THEN DO:
      ASSIGN
         Btn_Cancel:HIDDEN IN FRAME Dialog-Frame           = yes
         Btn_Cancel:HEIGHT IN FRAME Dialog-Frame           = 1.14
         Btn_Cancel:ROW IN FRAME Dialog-Frame              = 2.76
         Btn_Cancel:HIDDEN IN FRAME Dialog-Frame           = no.

      ASSIGN
         Btn_OK:HIDDEN IN FRAME Dialog-Frame               = yes
         Btn_OK:HEIGHT IN FRAME Dialog-Frame               = 1.14
         Btn_OK:ROW IN FRAME Dialog-Frame                  = 1.52
         Btn_OK:HIDDEN IN FRAME Dialog-Frame               = no.

      ASSIGN
         EDITOR-1:HIDDEN IN FRAME Dialog-Frame             = yes
         EDITOR-1:HEIGHT IN FRAME Dialog-Frame             = 3.81
         EDITOR-1:ROW IN FRAME Dialog-Frame                = 1.48
         EDITOR-1:HIDDEN IN FRAME Dialog-Frame             = no.

      ASSIGN
         EDITOR-2:HIDDEN IN FRAME Dialog-Frame             = yes
         EDITOR-2:HEIGHT IN FRAME Dialog-Frame             = 3.81
         EDITOR-2:ROW IN FRAME Dialog-Frame                = 6.95
         EDITOR-2:HIDDEN IN FRAME Dialog-Frame             = no.

      ASSIGN
         FILL-IN-1:HIDDEN IN FRAME Dialog-Frame            = yes
         FILL-IN-1:ROW IN FRAME Dialog-Frame               = 5.52
         FILL-IN-1:HIDDEN IN FRAME Dialog-Frame            = no.

    END.  /* Master Layout Layout Case */

    WHEN "Standard Character":U THEN DO:
      ASSIGN
         Btn_Cancel:HIDDEN IN FRAME Dialog-Frame           = yes
         Btn_Cancel:HEIGHT IN FRAME Dialog-Frame           = 1
         Btn_Cancel:ROW IN FRAME Dialog-Frame              = 7
         Btn_Cancel:HIDDEN IN FRAME Dialog-Frame           = no NO-ERROR.

      ASSIGN
         Btn_OK:HIDDEN IN FRAME Dialog-Frame               = yes
         Btn_OK:HEIGHT IN FRAME Dialog-Frame               = 1
         Btn_OK:ROW IN FRAME Dialog-Frame                  = 6
         Btn_OK:HIDDEN IN FRAME Dialog-Frame               = no NO-ERROR.

      ASSIGN
         EDITOR-1:HIDDEN IN FRAME Dialog-Frame             = yes
         EDITOR-1:HEIGHT IN FRAME Dialog-Frame             = 4
         EDITOR-1:ROW IN FRAME Dialog-Frame                = 1
         EDITOR-1:HIDDEN IN FRAME Dialog-Frame             = no NO-ERROR.

      ASSIGN
         EDITOR-2:HIDDEN IN FRAME Dialog-Frame             = yes
         EDITOR-2:HEIGHT IN FRAME Dialog-Frame             = 4
         EDITOR-2:ROW IN FRAME Dialog-Frame                = 7
         EDITOR-2:HIDDEN IN FRAME Dialog-Frame             = no NO-ERROR.

      ASSIGN
         FILL-IN-1:HIDDEN IN FRAME Dialog-Frame            = yes
         FILL-IN-1:ROW IN FRAME Dialog-Frame               = 6
         FILL-IN-1:HIDDEN IN FRAME Dialog-Frame            = no NO-ERROR.

    END.  /* Standard Character Layout Case */

  END CASE.
END PROCEDURE.  /* CURRENT-WINDOW-layouts */
&ANALYZE-RESUME

